/*
 * Decompiled with CFR 0.152.
 */
package com.pancake.campfire_resting.capability;

import com.pancake.campfire_resting.init.ModCapability;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestingCap
implements INBTSerializable<CompoundTag> {
    private int skipTime = 0;
    private boolean isResting = false;

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("skipTime", this.skipTime);
        compoundTag.m_128379_("isResting", this.isResting);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        this.skipTime = compoundTag.m_128451_("skipTime");
        this.isResting = compoundTag.m_128471_("isResting");
    }

    public static LazyOptional<RestingCap> get(Level level) {
        return level.getCapability(ModCapability.RESTING_CAP);
    }

    public int getSkipTime() {
        return this.skipTime;
    }

    public void setSkipTime(int skipTime) {
        this.skipTime = skipTime;
    }

    public boolean isResting() {
        return this.isResting;
    }

    public void setResting(boolean resting) {
        this.isResting = resting;
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<RestingCap> instance = LazyOptional.of(RestingCap::new);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return ModCapability.RESTING_CAP.orEmpty(cap, this.instance);
        }

        public CompoundTag serializeNBT() {
            return ((RestingCap)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"))).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((RestingCap)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!"))).deserializeNBT(nbt);
        }
    }
}

